//
// (c) 2020 wesolutions GmbH
// All rights reserved.
//

import QtQuick 2.4

import wesual.Controls 1.0

KeyEventSource {
    id : numPad

    readonly property color normalColor    : "#EEE"
    readonly property color highlightColor : "#7AC1DF"

    width  : childrenRect.width
    height : childrenRect.height

    Grid {
        id : container

        readonly property var keys : [
            [ Qt.Key_1, "1" ],
            [ Qt.Key_2, "2" ],
            [ Qt.Key_3, "3" ],
            [ Qt.Key_4, "4" ],
            [ Qt.Key_5, "5" ],
            [ Qt.Key_6, "6" ],
            [ Qt.Key_7, "7" ],
            [ Qt.Key_8, "8" ],
            [ Qt.Key_9, "9" ],
            [ Qt.Key_unknown, ""],
            [ Qt.Key_0, "0" ],
            [ Qt.Key_Backspace, "", "qrc:/controls/icons/key-backspace.png" ]
        ]

        spacing : 6
        rows    : 4
        columns : 3

        Component {
            id : buttonText

            Text {
                anchors {
                    centerIn : parent
                }
                font {
                    family    : "Lato"
                    weight    : Font.Light
                    pixelSize : 32
                }
                color : "#5F5F5F"
            }
        }

        Component {
            id : buttonIcon

            Image {
                anchors.centerIn : parent
            }
        }

        Component {
            id : button

            VirtualKey {
                property var keyData

                normalColor    : numPad.normalColor
                highlightColor : numPad.highlightColor
                onClicked      : numPad.triggerKeyEvent(keyData[0], keyData[1])

                anchors {
                    fill : parent
                }

                Component.onCompleted : {
                    if (keyData.length > 2) {
                        buttonIcon.createObject(this, {
                            "source" : keyData[2]
                        });
                    } else {
                        buttonText.createObject(this, { "text" : keyData[1] });
                    }
                }
            }
        }

        Repeater {
            model : container.keys

            delegate : Item {
                width  : 60
                height : 60

                Component.onCompleted : {
                    if (modelData[0] !== Qt.Key_unknown) {
                        button.createObject(this, { "keyData" : modelData });
                    }
                }
            }
        }
    }
}

